# Generated by Django 5.2.3 on 2025-07-28 06:31

import django.db.models.deletion
import django.utils.timezone
import shortuuid.django_fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('carts', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Brand',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='MultiProductImages',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(blank=True, null=True, upload_to='product/')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_name', models.CharField(max_length=255)),
                ('description', models.TextField()),
                ('details', models.JSONField(blank=True, default=list)),
                ('attributes', models.JSONField(blank=True, default=dict, null=True)),
                ('type', models.CharField(choices=[('ma', 'Man'), ('wo', 'Woman')], default='ma', max_length=2)),
                ('condition', models.CharField(choices=[('New', 'New'), ('Use', 'Use'), ('Other', 'Other')], default='New', max_length=20)),
                ('price', models.IntegerField()),
                ('stock', models.IntegerField()),
                ('image_url', models.ImageField(blank=True, null=True, upload_to='product/image')),
                ('hover_image_url', models.ImageField(blank=True, null=True, upload_to='product/image')),
                ('seller_notes', models.TextField()),
                ('material', models.CharField(max_length=500)),
                ('image', models.ImageField(blank=True, null=True, upload_to='product/image')),
                ('weight', models.PositiveSmallIntegerField()),
                ('is_available', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='CartOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('total', models.DecimalField(decimal_places=2, default=0.0, max_digits=12)),
                ('payment_status', models.CharField(choices=[('paid', 'Paid'), ('pending', 'Pending'), ('processing', 'Processing'), ('cancelled', 'Cancelled'), ('initiated', 'Initiated'), ('failed', 'Failed'), ('refunding', 'Refunding'), ('refunded', 'Refunded'), ('unpaid', 'Unpaid'), ('expired', 'Expired')], default='initiated', max_length=100)),
                ('order_status', models.CharField(choices=[('Pending', 'Pending'), ('Fulfilled', 'Fulfilled'), ('Partially Fulfilled', 'Partially Fulfilled'), ('Cancelled', 'Cancelled')], default='Pending', max_length=100)),
                ('full_name', models.CharField(max_length=1000)),
                ('email', models.EmailField(max_length=1000)),
                ('mobile', models.CharField(max_length=1000)),
                ('address', models.CharField(blank=True, max_length=1000, null=True)),
                ('city', models.CharField(blank=True, max_length=1000, null=True)),
                ('state', models.CharField(blank=True, max_length=1000, null=True)),
                ('country', models.CharField(blank=True, max_length=1000, null=True)),
                ('oid', shortuuid.django_fields.ShortUUIDField(alphabet='abcdefghijklmnopqrstuvxyz', length=30, max_length=40, prefix='')),
                ('date', models.DateTimeField(default=django.utils.timezone.now)),
                ('delivery_courier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='carts.deliverycouriers')),
            ],
            options={
                'verbose_name_plural': 'Cart Orders',
                'ordering': ['-date'],
            },
        ),
    ]
